<?php
session_start();
include 'includes/auth.php';
include 'includes/db.php';

// Validate ID
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: members_all.php");
    exit;
}

$id = (int)$_GET['id'];
$result = mysqli_query($conn, "SELECT * FROM members WHERE id = $id");
if (mysqli_num_rows($result) == 0) {
    echo "<div class='alert alert-danger'>Member not found.</div>";
    exit;
}
$member = mysqli_fetch_assoc($result);
?>

<?php include 'includes/header.php'; ?>
<div class="container my-4">
    <h2>Member Details: <?php echo htmlspecialchars($member['first_name'] . ' ' . $member['surname']); ?></h2>
    <div class="row">
        <div class="col-md-3">
            <?php if (!empty($member['photo'])): ?>
                <img src="uploads/<?php echo htmlspecialchars($member['photo']); ?>" class="img-thumbnail mb-3" alt="Member Photo">
            <?php endif; ?>
        </div>
        <div class="col-md-9">
            <table class="table table-bordered">
                <tbody>
                    <tr><th>Member Number</th><td><?php echo $member['member_number']; ?></td></tr>
                    <tr><th>Name</th><td><?php echo htmlspecialchars($member['first_name'] . ' ' . $member['middle_name'] . ' ' . $member['surname']); ?></td></tr>
                    <tr><th>Email</th><td><?php echo htmlspecialchars($member['email']); ?></td></tr>
                    <tr><th>Phone</th><td><?php echo htmlspecialchars($member['phone']); ?></td></tr>
                    <tr><th>Gender</th><td><?php echo $member['gender']; ?></td></tr>
                    <tr><th>Date of Birth</th><td><?php echo $member['dob']; ?></td></tr>
                    <tr><th>Address</th><td><?php echo nl2br(htmlspecialchars($member['address'])); ?></td></tr>
                    <tr><th>Membership Type</th><td><?php echo $member['membership_type']; ?></td></tr>
                    <tr><th>Joined</th><td><?php echo $member['joined']; ?></td></tr>
                    <tr><th>Paid Amount</th><td><?php echo $member['paid_amount']; ?></td></tr>
                    <tr><th>Paid Date</th><td><?php echo $member['paid_date']; ?></td></tr>
                    <tr><th>Expiry Date</th><td><?php echo $member['expiry_date']; ?></td></tr>
                    <tr><th>Payment Status</th><td><?php echo $member['payment_status']; ?></td></tr>
                    <tr><th>Next of Kin</th><td><?php echo htmlspecialchars($member['next_of_kin']); ?> (<?php echo $member['relationship']; ?>)</td></tr>
                    <tr><th>Next of Kin Phone</th><td><?php echo $member['next_of_kin_phone']; ?></td></tr>
                    <tr><th>Permission to Contact</th><td><?php echo $member['permission']; ?></td></tr>
                    <tr><th>Medical Condition</th><td><?php echo $member['medical_condition']; ?></td></tr>
                    <tr><th>Current Medication</th><td><?php echo $member['current_medication']; ?></td></tr>
                    <tr><th>Notes</th><td><?php echo $member['notes']; ?></td></tr>
                    <tr><th>Waiver Print Name</th><td><?php echo $member['waiver_print_name']; ?></td></tr>
                    <tr><th>Signature Date</th><td><?php echo $member['signature_date']; ?></td></tr>
                    <tr><th>Signature 1</th><td>
                        <?php if (!empty($member['signature_data1'])): ?>
                            <img src="<?php echo $member['signature_data1']; ?>" class="img-fluid border">
                        <?php else: ?>N/A<?php endif; ?>
                    </td></tr>
                    <tr><th>Signature 2</th><td>
                        <?php if (!empty($member['signature_data2'])): ?>
                            <img src="<?php echo $member['signature_data2']; ?>" class="img-fluid border">
                        <?php else: ?>N/A<?php endif; ?>
                    </td></tr>
                </tbody>
            </table>
        </div>
    </div>

    <h4>Health Questions</h4>
    <table class="table table-sm table-bordered">
        <thead><tr><th>#</th><th>Question</th><th>Answer</th></tr></thead>
        <tbody>
            <?php
            $questions = [
                "Do you lose your balance because of dizziness, or do you ever lose consciousness?",
                "Has your doctor ever said you have a heart condition and should only do physical activity recommended by a doctor?",
                "Do you feel pain in your chest when you do physical activity?",
                "Are you being treated for high blood pressure?",
                "Do you have diabetes?",
                "Do you have asthma or any other respiratory problems?",
                "Do you have any bone or joint problems that could be made worse by a change in your physical activity?",
                "Do you have epilepsy?",
                "Do you have a pacemaker?",
                "Are you pregnant?",
                "Do you know any other reasons you should not engage in physical activity?"
            ];

            for ($i = 1; $i <= 11; $i++) {
                $ans = htmlspecialchars($member["q$i"]);
                echo "<tr><td>$i</td><td>{$questions[$i-1]}</td><td>$ans</td></tr>";
            }
            ?>
        </tbody>
    </table>

    <h4>Other Info</h4>
    <div class="border p-2 mb-4"><?php echo nl2br(htmlspecialchars($member['other_info'])); ?></div>

    <a href="members_all.php" class="btn btn-secondary">Back</a>
</div>
<?php include 'includes/footer.php'; ?>
